# Brevo Email Service Setup Guide

This guide will help you set up Brevo (formerly Sendinblue) for sending emails from the Migration.ng portal.

## Prerequisites

1. A Brevo account (sign up at https://www.brevo.com/)
2. Composer installed on your system
3. PHP 7.4 or higher

## Step 1: Install Dependencies

The project uses an external Composer setup located at `Packages/`. The Brevo SDK is already configured there. If you need to install or update dependencies, run:

```bash
cd Packages
composer install
```

## Step 2: Get Your Brevo API Key

1. Log in to your Brevo account
2. Go to Settings > API Keys
3. Create a new API key with "Transactional Email" permissions
4. Copy the API key

## Step 3: Configure the API Key

You have two options to set your API key:

### Option A: Environment Variable (Recommended)

Set the environment variable in your server configuration:

```bash
export BREVO_API_KEY=your_actual_api_key_here
```

### Option B: Configuration File

Edit `config/brevo.php` and replace `'YOUR_BREVO_API_KEY_HERE'` with your actual API key:

```php
'api_key' => 'your_actual_api_key_here',
```

## Step 4: Verify Configuration

The EmailService will automatically use Brevo for sending emails. You can test it by:

1. Submitting a contact form
2. Creating a new application
3. Registering a new user

## Step 5: Monitor Email Delivery

1. Check your Brevo dashboard for email delivery statistics
2. Monitor the application logs for any email errors
3. Check the "Transactional Email" section in Brevo for delivery status

## Configuration Options

The `config/brevo.php` file contains several configuration options:

- `sender_email`: Default sender email address
- `sender_name`: Default sender name
- `reply_to`: Reply-to email address
- `debug`: Enable/disable debug mode
- `max_retries`: Maximum retry attempts for failed emails
- `retry_delay`: Delay between retry attempts

## Email Templates

The system includes several email templates:

- Welcome emails for new users
- Application confirmation emails
- Contact form notifications
- Password reset emails
- Application status updates

## Troubleshooting

### Common Issues

1. **API Key Error**: Make sure your API key is correct and has the right permissions
2. **Email Not Sending**: Check the error logs for detailed error messages
3. **Configuration Error**: Verify that the `config/brevo.php` file exists and is readable

### Error Logs

Check the following locations for error logs:
- Application error log: `error_log`
- PHP error log (check your server configuration)
- Brevo dashboard for delivery issues

## Security Notes

- Never commit your actual API key to version control
- Use environment variables in production
- Regularly rotate your API keys
- Monitor your Brevo account for unusual activity

## Support

If you encounter issues:
1. Check the Brevo documentation: https://developers.brevo.com/
2. Review the application error logs
3. Contact the development team 