# Email Verification Feature

This document describes the email verification system implemented for user registration on Migration.ng.

## Overview

The email verification feature ensures that users verify their email addresses before they can access their accounts. This helps prevent fake accounts and ensures that users can receive important notifications about their applications.

## Features

- **Email Verification Required**: New users must verify their email before logging in
- **Secure Token System**: Uses cryptographically secure tokens for verification
- **24-Hour Expiration**: Verification links expire after 24 hours for security
- **Resend Functionality**: Users can request new verification emails
- **Existing User Compatibility**: Existing users are automatically marked as verified
- **Professional Email Templates**: Beautiful, branded email templates

## Database Changes

The following fields are added to the `users` table:

- `email_verified` (BOOLEAN) - Whether the email has been verified
- `email_verification_token` (VARCHAR(255)) - Secure token for verification
- `email_verification_expires` (TIMESTAMP) - Token expiration time

## Files Added/Modified

### New Files
- `includes/EmailVerification.php` - Email verification logic
- `portal/verify-email.php` - Email verification page
- `portal/sql/email_verification_migration.sql` - Database migration
- `run_email_verification_migration.php` - Migration script

### Modified Files
- `includes/EmailService.php` - Added email verification email templates
- `portal/login.php` - Modified registration and login to include verification
- `includes/UserAuth.php` - Updated to check email verification status

## Installation

1. **Run the Migration**:
   ```bash
   php run_email_verification_migration.php
   ```

2. **Verify Installation**:
   - Check that the new columns exist in the `users` table
   - Test user registration to ensure verification emails are sent
   - Test email verification link functionality

## How It Works

### Registration Process
1. User fills out registration form
2. Account is created with `email_verified = FALSE`
3. Verification token is generated and stored
4. Verification email is sent to user
5. User receives success message asking them to check email

### Email Verification Process
1. User clicks verification link in email
2. System validates the token and expiration time
3. If valid, `email_verified` is set to `TRUE`
4. Token is cleared from database
5. User is redirected to login page

### Login Process
1. User attempts to log in
2. System checks if email is verified
3. If not verified, user sees error message with link to resend verification
4. If verified, login proceeds normally

### Resend Verification
1. User visits verification page without token
2. User enters email address
3. New verification token is generated
4. New verification email is sent

## Email Templates

The system includes two email templates:

1. **Initial Verification Email** - Sent when user registers
2. **Reminder Email** - Sent when user requests a new verification

Both templates include:
- Professional branding
- Clear call-to-action buttons
- Security notices
- Mobile-responsive design

## Security Features

- **Secure Tokens**: Uses `random_bytes(32)` for token generation
- **Time Expiration**: Tokens expire after 24 hours
- **Single Use**: Tokens are cleared after successful verification
- **CSRF Protection**: All forms include CSRF tokens
- **Input Validation**: All inputs are validated and sanitized

## Configuration

The email verification system uses the existing Brevo email service configuration. No additional configuration is required.

## Testing

To test the email verification system:

1. **Register a new user** with a valid email address
2. **Check email** for verification link
3. **Click verification link** to activate account
4. **Try logging in** with the new account
5. **Test resend functionality** by visiting verification page without token

## Troubleshooting

### Common Issues

1. **Emails not sending**:
   - Check Brevo API configuration
   - Verify email service is working
   - Check server logs for errors

2. **Verification links not working**:
   - Ensure tokens are being generated correctly
   - Check database for token storage
   - Verify expiration times

3. **Existing users can't log in**:
   - Run migration script to mark existing users as verified
   - Check `email_verified` field values

### Debug Mode

To enable debug mode, set `ENVIRONMENT` to `'development'` in the relevant files.

## Future Enhancements

Potential improvements to consider:

- **Email Change Verification**: Verify email when users change their email address
- **Multiple Email Support**: Allow users to add multiple email addresses
- **SMS Verification**: Add SMS verification as an alternative
- **Two-Factor Authentication**: Integrate with 2FA system
- **Verification Analytics**: Track verification rates and success

## Support

For issues or questions about the email verification system, contact the development team or check the server logs for detailed error messages. 