# Migration.ng - Improved Web Application

A PHP-based web application for migration services, specifically designed to help Nigerians with international migration processes, particularly for educational purposes.

## 🚀 Recent Improvements

This application has been significantly improved with the following enhancements:

### 🔒 Security Improvements
- **Centralized Database Configuration**: Moved database credentials to a separate config file
- **CSRF Protection**: Implemented CSRF token validation for all forms
- **Input Validation & Sanitization**: Comprehensive validation system for all user inputs
- **File Upload Security**: Enhanced file validation with MIME type checking and safe filename generation
- **Error Handling**: Replaced basic `die()` statements with proper error handling

### 🏗️ Code Organization
- **Modular Architecture**: Separated concerns into dedicated classes and files
- **Centralized Error Handling**: Comprehensive error logging and user-friendly error messages
- **Email Service**: Centralized email functionality with HTML templates
- **Validation System**: Reusable validation methods for all form inputs

### 📧 Enhanced Email System
- **Professional HTML Templates**: Beautiful, responsive email templates
- **User Confirmation Emails**: Automatic confirmation emails to users
- **Admin Notifications**: Enhanced admin notification emails
- **Error Handling**: Proper email error handling and logging

### 🛡️ File Upload Security
- **MIME Type Validation**: Verifies actual file content, not just extensions
- **Safe Filename Generation**: Prevents path traversal and filename conflicts
- **Size Limits**: Enforced file size restrictions
- **Type Restrictions**: Strict file type validation

## 📁 Project Structure

```
├── config/
│   └── database.php              # Database configuration
├── includes/
│   ├── Validator.php             # Input validation and sanitization
│   ├── ErrorHandler.php          # Error handling and logging
│   └── EmailService.php          # Email functionality
├── templates/
│   └── error.php                 # Error page template
├── arrays/
│   └── countries.php             # Country data
├── assets/
│   ├── css/                      # Stylesheets
│   └── images/                   # Images and logos
├── uploads/                      # User document uploads
├── logs/                         # Error logs (auto-created)
├── index.php                     # Main application page
├── contact.php                   # Contact form
├── about.php                     # About page
├── nav.php                       # Navigation component
├── footer.php                    # Footer component
└── .htaccess                     # URL rewriting rules
```

## 🛠️ Setup Instructions

### Prerequisites
- PHP 7.4 or higher
- MySQL 5.7 or higher
- Apache web server with mod_rewrite enabled
- Composer (optional, for future package management)

### Installation

1. **Clone or download the project**
   ```bash
   git clone <repository-url>
   cd migration.ng
   ```

2. **Configure Database**
   - Create a MySQL database named `migrati1_main`
   - Import the provided SQL files:
     - `uni_requests.sql` - University application requests table
     - `universities.sql` - Universities data table
   - Update database credentials in `config/database.php`

3. **Set File Permissions**
   ```bash
   chmod 755 uploads/
   chmod 755 logs/
   chmod 644 config/database.php
   ```

4. **Configure Web Server**
   - Point your web server document root to the project directory
   - Ensure `.htaccess` is enabled for URL rewriting
   - Configure PHP to allow file uploads (check `upload_max_filesize` and `post_max_size`)

5. **Email Configuration (Brevo Integration)**
   - The Brevo SDK is configured in the external `Packages/` directory
   - Copy `config/brevo.example.php` to `config/brevo.php`
   - Set your Brevo API key in the configuration file or as environment variable
   - See `BREVO_SETUP.md` for detailed setup instructions

### Environment Configuration

The application uses environment-based configuration:

```php
// In any PHP file
define('ENVIRONMENT', 'production'); // or 'development'
```

- **Production**: Errors are logged but not displayed to users
- **Development**: Errors are displayed for debugging

## 🔧 Key Features

### University Application System
- Collects student information for university applications
- Stores data in MySQL database
- Sends notification emails to admin and confirmation emails to users
- Supports multiple countries and universities

### Document Upload System
- Secure file upload with validation
- Supports: JPG, PNG, PDF, DOC, DOCX
- 5MB file size limit per file
- Creates individual folders for each user
- Generates safe filenames to prevent conflicts

### Contact Form
- Validated contact form with CSRF protection
- Sends professional HTML emails
- User-friendly error and success messages

### Resource Pages
- Cost of living information for different countries
- English-speaking countries guide
- UK study and skilled worker guidance

## 🔒 Security Features

- **CSRF Protection**: All forms include CSRF tokens
- **Input Sanitization**: All user inputs are validated and sanitized
- **File Upload Security**: Comprehensive file validation
- **Error Logging**: All errors are logged for monitoring
- **SQL Injection Prevention**: Prepared statements for all database queries
- **XSS Prevention**: Output encoding for all user data

## 📧 Email Templates

The application includes professional HTML email templates for:
- University application notifications
- Contact form submissions
- User confirmation emails

All emails are responsive and include proper branding.

## 🐛 Error Handling

- **Centralized Error Handling**: All errors are handled consistently
- **User-Friendly Messages**: Users see helpful error messages
- **Error Logging**: All errors are logged to `logs/error.log`
- **Development Mode**: Detailed error information in development

## 📊 Database Schema

### uni_requests Table
```sql
CREATE TABLE uni_requests (
  id int NOT NULL AUTO_INCREMENT,
  country varchar(20) NOT NULL,
  university varchar(40) NOT NULL,
  degree varchar(20) NOT NULL,
  firstname varchar(40) NOT NULL,
  lastname varchar(40) NOT NULL,
  email varchar(40) NOT NULL,
  PRIMARY KEY (id)
);
```

### universities Table
```sql
CREATE TABLE universities (
  id int NOT NULL AUTO_INCREMENT,
  name varchar(114) NOT NULL,
  country varchar(38) NOT NULL,
  alpha_two_code varchar(2) NOT NULL,
  web_pages0 varchar(62) NOT NULL,
  domains0 varchar(44) NOT NULL,
  -- Additional fields for multiple web pages and domains
  PRIMARY KEY (id)
);
```

## 🚀 Future Enhancements

- **Admin Panel**: Web-based admin interface for managing applications
- **Payment Integration**: Enhanced Paystack integration
- **API Development**: RESTful API for mobile applications
- **Email Templates**: More customizable email templates
- **File Management**: Better file organization and management
- **User Authentication**: User registration and login system

## 📞 Support

For support or questions, please contact:
- Email: services@migration.ng
- Website: https://migration.ng

## 📄 License

This project is proprietary software developed for Migration.ng.

---

**Note**: This application is designed for production use and includes comprehensive security measures. Always keep your dependencies updated and monitor error logs regularly. 