<?php include_once '../nav.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <title>Cost of Living in Different Countries</title>
  <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.7/dist/tailwind.min.css" rel="stylesheet">
</head>
<body>
  <div class="max-w-7xl mx-auto px-4 py-12 sm:px-6 lg:px-8">
    <h1 class="text-3xl font-bold mb-8">Cost of Living in Different Countries</h1>

    <p class="mb-8">Below is a table showing the average cost of living in different countries. Please note that these figures are estimates and may vary depending on the specific location and lifestyle choices.</p>

    <div class="overflow-x-auto mb-8">
      <table class="table-auto w-full border-collapse border border-gray-500">
        <thead>
          <tr class="bg-gray-50">
            <th class="px-6 py-3 text-left text-xs font-medium text-white uppercase tracking-wider bg-primary-700">Country</th>
            <th class="px-6 py-3 text-left text-xs font-medium text-white uppercase tracking-wider bg-primary-700">Rent (monthly)</th>
            <th class="px-6 py-3 text-left text-xs font-medium text-white uppercase tracking-wider bg-primary-700">Food (monthly)</th>
            <th class="px-6 py-3 text-left text-xs font-medium text-white uppercase tracking-wider bg-primary-700">Transportation (monthly)</th>
            <th class="px-6 py-3 text-left text-xs font-medium text-white uppercase tracking-wider bg-primary-700">Healthcare (monthly)</th>
            <th class="px-6 py-3 text-left text-xs font-medium text-white uppercase tracking-wider bg-primary-700">Other Expenses (monthly)</th>
            <th class="px-6 py-3 text-left text-xs font-medium text-white uppercase tracking-wider bg-primary-700">Total Cost of Living (monthly)</th>
          </tr>
        </thead>
        <tbody>
          <tr class="border-t border-gray-500">
            <td class="px-6 py-4 whitespace-nowrap">United States</td>
            <td class="px-6 py-4 whitespace-nowrap">$1,500</td>
            <td class="px-6 py-4 whitespace-nowrap">$250</td>
            <td class="px-6 py-4 whitespace-nowrap">$100</td>
            <td class="px-6 py-4 whitespace-nowrap">$400</td>
            <td class="px-6 py-4 whitespace-nowrap">$200</td>
            <td class="px-6 py-4 whitespace-nowrap">$2,450</td>
          </tr>
          <tr class="border-t border-gray-500">
            <td class="px-6 py-4 whitespace-nowrap">Canada</td>
            <td class="px-6 py-4 whitespace-nowrap">$1,200</td>
            <td class="px-6 py-4 whitespace-nowrap">$200</td>
            <td class="px-6 py-4 whitespace-nowrap">$100</td>
            <td class="px-6 py-4 whitespace-nowrap">$350</td>
            <td class="px-6 py-4 whitespace-nowrap">$150</td>
            <td class="px-6 py-4 whitespace-nowrap">$2,000</td>
          </tr>
          <tr class="border-t border-gray-500">
            <td class="px-6 py-4 whitespace-nowrap">United Kingdom</td>
            <td class="px-6 py-4 whitespace-nowrap">£900</td>
            <td class="px-6 py-4 whitespace-nowrap">£150</td>
            <td class="px-6 py-4 whitespace-nowrap">£75</td>
            <td class="px-6 py-4 whitespace-nowrap">£200</td>
            <td class="px-6 py-4 whitespace-nowrap">£100</td>
            <td class="px-6 py-4 whitespace-nowrap">£1,525</td>
          </tr>
          <tr class="border-t border-gray-500">
            <td class="px-6 py-4 whitespace-nowrap">Australia</td>
            <td class="px-6 py-4 whitespace-nowrap">$1,800</td>
            <td class="px-6 py-4 whitespace-nowrap">$300</td>
            <td class="px-6 py-4 whitespace-nowrap">$150</td>
            <td class="px-6 py-4 whitespace-nowrap">$300</td>
            <td class="px-6 py-4 whitespace-nowrap">$150</td>
            <td class="px-6 py-4 whitespace-nowrap">$2,700</td>
          </tr>
          <tr class="border-t border-gray-500">
            <td class="px-6 py-4 whitespace-nowrap">Germany</td>
            <td class="px-6 py-4 whitespace-nowrap">€800</td>
            <td class="px-6 py-4 whitespace-nowrap">€150</td>
            <td class="px-6 py-4 whitespace-nowrap">€80</td>
            <td class="px-6 py-4 whitespace-nowrap">€200</td>
            <td class="px-6 py-4 whitespace-nowrap">€100</td>
            <td class="px-6 py-4 whitespace-nowrap">€1,330</td>
          </tr>
          <tr class="border-t border-gray-500">
            <td class="px-6 py-4 whitespace-nowrap">Spain</td>
            <td class="px-6 py-4 whitespace-nowrap">€600</td>
            <td class="px-6 py-4 whitespace-nowrap">€100</td>
            <td class="px-6 py-4 whitespace-nowrap">€50</td>
            <td class="px-6 py-4 whitespace-nowrap">€150</td>
            <td class="px-6 py-4 whitespace-nowrap">€75</td>
            <td class="px-6 py-4 whitespace-nowrap">€975</td>
          </tr>
        </tbody>
      </table>
    </div>

    <p class="mb-8">As you can see, the cost of living varies widely depending on the country you choose to move to. It's important to carefully consider the cost of living, along with other factors such as job opportunities, education, and lifestyle, before making a decision about where to move.</p>

    <p class="mb-8">It's also worth noting that the cost of living can vary widely within a single country, so it's important to research specific cities and regions to get a more accurate idea of the cost of living in your desired location.</p>

    <p class="mb-8">Finally, it's a good idea to make a budget and plan for your expenses before you move. This will help you ensure that you have enough money to cover your basic needs, as well as any unexpected expenses that may arise.</p>

    <p class="mb-8">Remember, moving to a new country can be a big change, but with careful planning and research, you can make a smooth transition and enjoy a new adventure!</p>
  </div>
</body>
<?php include_once '../footer.php'; ?>

</html>

