<?php 
require_once '../config/whatsapp.php';
include_once '../nav.php'; 
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Resources</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/tailwindcss/2.1.2/tailwind.min.css" integrity="sha512-QLhoZNCTtJnIb+rgZOk1Ltwq1qjJTYcH+PnNZ9FHZJCU4kJ4ae4k/TfbwOL+ZIkwAyejJg+EYUGnvb5v5yP+og==" crossorigin="anonymous" />
</head>
<body>
<div class="grid grid-cols-4 gap-4">
   
        <?php
        
        echo
        template(
        'https://bonnyrigg-h.schools.nsw.gov.au/content/dam/doe/sws/schools/b/bonnyrigg-h/supporting-our-students/subject-list/English_Banner.jpg.thumb.1280.1280.jpg',
        'Countries with English as an Official Language',
        ' Here are some countries where English is an official language and information about studying and working in each country.',
        'https://migration.ng/Resources/englishspeaking') .
        
        template(
        'https://upload.wikimedia.org/wikipedia/en/thumb/c/c3/UKVisas.svg/330px-UKVisas.svg.png', 
        'Study Guidiance',
        'This is a document retrieved from the UK Home Office, it contains guidelines by which Visa Officers follow to grant or deny visas to applicants applying for study visas.',
        'https://migration.ng/Resources/uk_studyguidance') .
        
        template(
        'https://upload.wikimedia.org/wikipedia/en/thumb/c/c3/UKVisas.svg/330px-UKVisas.svg.png', 
        'Skilled Worker Guidiance',
        'This is a document retrieved from the UK Home Office, it contains guidelines by which Visa Officers follow to grant or deny visas to applicants applying for skilled worker visas.',
        'https://migration.ng/Resources/uk_skilledworkerguidance') 
        
        
        
        ?>
    
    </div>
    
    <!-- Floating WhatsApp Button -->
    <a href="<?php echo WHATSAPP_LINK; ?>" target="_blank" class="fixed bottom-6 right-6 z-50 bg-green-500 hover:bg-green-600 text-white rounded-full p-4 shadow-lg transition-all duration-300 transform hover:scale-110 hover:shadow-xl">
        <i class="fab fa-whatsapp text-2xl"></i>
    </a>
</body>
<?php 

function template($img, $title, $subtitle, $link){
    return "
    <div>
<div class='max-w-2xl mx-auto'>
    
    <div class='bg-white shadow-md border border-gray-200 rounded-lg max-w-sm dark:bg-gray-800 dark:border-gray-700'>
        <a href='#'>
            <img class='rounded-t-lg' src='$img' alt=''>
        </a>
        <div class='p-5'>
            <a href='$link'>
                <h5 class='text-gray-900 font-bold text-2xl tracking-tight mb-2 dark:text-white'>$title</h5>
            </a>
            <p class='font-normal text-gray-700 mb-3 dark:text-gray-400'>$subtitle</p>
            <a href='$link' class='text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:ring-blue-300 font-medium rounded-lg text-sm px-3 py-2 text-center inline-flex items-center  dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800'>
                Read more
                <svg class='-mr-1 ml-2 h-4 w-4' fill='currentColor' viewBox='0 0 20 20' xmlns='http://www.w3.org/2000/svg'><path fill-rule='evenodd' d='M10.293 3.293a1 1 0 011.414 0l6 6a1 1 0 010 1.414l-6 6a1 1 0 01-1.414-1.414L14.586 11H3a1 1 0 110-2h11.586l-4.293-4.293a1 1 0 010-1.414z' clip-rule='evenodd'></path></svg>
            </a>
        </div>
    </div>

</div>
</div>";
}

include_once '../footer.php'; ?>

</html>

