<?php
require_once 'config/whatsapp.php';
include("nav.php");
?>

<!doctype html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests">
  
  <!-- Favicon -->
  <link rel="icon" type="image/x-icon" href="assets/favicon/favicon.ico">
  <link rel="icon" type="image/png" sizes="16x16" href="assets/favicon/favicon-16x16.png">
  <link rel="icon" type="image/png" sizes="32x32" href="assets/favicon/favicon-32x32.png">
  <link rel="apple-touch-icon" sizes="180x180" href="assets/favicon/apple-touch-icon.png">
  <link rel="manifest" href="assets/favicon/site.webmanifest">
    
    <!-- Tailwind CSS -->
    <script src="https://ibex.bg/umm/assets/js/tailwind.js"></script>
    
    <title>About Us - Migration.ng</title>
</head>
<body class="bg-gray-50 dark:bg-gray-900">

    <!-- Hero Section -->
    <section class="bg-gradient-to-br from-blue-600 via-blue-700 to-indigo-800 text-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16 lg:py-24">
            <div class="text-center">
                <h1 class="text-4xl md:text-5xl lg:text-6xl font-bold mb-6">
                    About Migration.ng
                </h1>
                <p class="text-xl md:text-2xl text-blue-100 max-w-3xl mx-auto">
                    Making migration easier for Nigerians through a global network of professionals and students.
                </p>
            </div>
        </div>
    </section>

    <!-- Mission Section -->
    <section class="py-16 lg:py-24">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-6">
                    Our Mission
                </h2>
                <p class="text-xl text-gray-600 dark:text-gray-300 max-w-4xl mx-auto">
                    We're a global community of professionals and students dedicated to simplifying the migration process for Nigerians, 
                    especially for educational purposes. Our network spans across continents, bringing local expertise to your migration journey.
                </p>
            </div>

            <!-- Mission Cards -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8 mb-16">
                <div class="bg-white dark:bg-gray-800 rounded-xl p-8 shadow-lg border border-gray-200 dark:border-gray-700 text-center">
                    <div class="w-16 h-16 bg-blue-100 dark:bg-blue-900 rounded-full flex items-center justify-center mx-auto mb-6">
                        <svg class="w-8 h-8 text-blue-600 dark:text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-white mb-4">Global Network</h3>
                    <p class="text-gray-600 dark:text-gray-300">
                        Our team spans across continents with professionals in various fields including lawyers, doctors, 
                        travel advisors, and students who understand the migration process firsthand.
                    </p>
                </div>

                <div class="bg-white dark:bg-gray-800 rounded-xl p-8 shadow-lg border border-gray-200 dark:border-gray-700 text-center">
                    <div class="w-16 h-16 bg-green-100 dark:bg-green-900 rounded-full flex items-center justify-center mx-auto mb-6">
                        <svg class="w-8 h-8 text-green-600 dark:text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-white mb-4">Local Expertise</h3>
                    <p class="text-gray-600 dark:text-gray-300">
                        We operate with a person-to-person model, ensuring you have local experts handling your specific needs, 
                        whether it's document processing in Abuja or university applications in Norway.
                    </p>
                </div>

                <div class="bg-white dark:bg-gray-800 rounded-xl p-8 shadow-lg border border-gray-200 dark:border-gray-700 text-center">
                    <div class="w-16 h-16 bg-purple-100 dark:bg-purple-900 rounded-full flex items-center justify-center mx-auto mb-6">
                        <svg class="w-8 h-8 text-purple-600 dark:text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-white mb-4">Fast & Reliable</h3>
                    <p class="text-gray-600 dark:text-gray-300">
                        We respond to all inquiries within 24 working hours and provide real-time updates on your application progress 
                        through our comprehensive portal system.
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- How We Work Section -->
    <section class="bg-white dark:bg-gray-800 py-16 lg:py-24">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-6">
                    How We Work
                </h2>
                <p class="text-xl text-gray-600 dark:text-gray-300 max-w-3xl mx-auto">
                    Our streamlined process ensures your migration journey is smooth and stress-free.
                </p>
            </div>

            <!-- Process Steps -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                <div class="text-center">
                    <div class="w-16 h-16 bg-blue-600 text-white rounded-full flex items-center justify-center mx-auto mb-6 text-2xl font-bold">
                        1
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-3">Initial Consultation</h3>
                    <p class="text-gray-600 dark:text-gray-300">
                        Contact us with your migration goals and we'll assess your needs and provide a personalized plan.
                    </p>
                </div>

                <div class="text-center">
                    <div class="w-16 h-16 bg-blue-600 text-white rounded-full flex items-center justify-center mx-auto mb-6 text-2xl font-bold">
                        2
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-3">Document Preparation</h3>
                    <p class="text-gray-600 dark:text-gray-300">
                        We help you gather and prepare all necessary documents, ensuring they meet the required standards.
                    </p>
              </div>

                <div class="text-center">
                    <div class="w-16 h-16 bg-blue-600 text-white rounded-full flex items-center justify-center mx-auto mb-6 text-2xl font-bold">
                        3
              </div>
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-3">Application Processing</h3>
                    <p class="text-gray-600 dark:text-gray-300">
                        Our local experts handle your applications, leveraging their knowledge of local requirements and procedures.
                    </p>
              </div>

                <div class="text-center">
                    <div class="w-16 h-16 bg-blue-600 text-white rounded-full flex items-center justify-center mx-auto mb-6 text-2xl font-bold">
                        4
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-3">Ongoing Support</h3>
                    <p class="text-gray-600 dark:text-gray-300">
                        Track your progress through our portal and receive updates every step of the way until completion.
                    </p>
                </div>
              </div>
          </div>
    </section>

    <!-- FAQ Section -->
    <section class="py-16 lg:py-24">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-6">
                    Frequently Asked Questions
                </h2>
                <p class="text-xl text-gray-600 dark:text-gray-300">
                    Get answers to the most common questions about our services.
                </p>
            </div>

            <div class="space-y-8">
                <!-- FAQ Item 1 -->
                <div class="bg-white dark:bg-gray-800 rounded-xl p-8 shadow-lg border border-gray-200 dark:border-gray-700">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-white mb-4 flex items-center">
                        <svg class="w-6 h-6 text-blue-600 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.228 9c.549-1.165 2.03-2 3.772-2 2.21 0 4 1.343 4 3 0 1.4-1.278 2.575-3.006 2.907-.542.104-.994.54-.994 1.093m0 3h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        Can I have multiple applications simultaneously?
                  </h3>
                    <p class="text-gray-600 dark:text-gray-300">
                        Absolutely! We understand that you may want to have multiple options available. You can submit and track multiple applications 
                        simultaneously through our portal, ensuring you have the best chances of success.
                    </p>
              </div>

                <!-- FAQ Item 2 -->
                <div class="bg-white dark:bg-gray-800 rounded-xl p-8 shadow-lg border border-gray-200 dark:border-gray-700">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-white mb-4 flex items-center">
                        <svg class="w-6 h-6 text-blue-600 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.228 9c.549-1.165 2.03-2 3.772-2 2.21 0 4 1.343 4 3 0 1.4-1.278 2.575-3.006 2.907-.542.104-.994.54-.994 1.093m0 3h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        How do payments work?
                  </h3>
                    <p class="text-gray-600 dark:text-gray-300">
                        All payments are processed securely through our integrated Paystack solution. We offer transparent pricing with no hidden fees, 
                        and you'll receive detailed invoices for all services.
                    </p>
                </div>

                <!-- FAQ Item 3 -->
                <div class="bg-white dark:bg-gray-800 rounded-xl p-8 shadow-lg border border-gray-200 dark:border-gray-700">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-white mb-4 flex items-center">
                        <svg class="w-6 h-6 text-blue-600 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.228 9c.549-1.165 2.03-2 3.772-2 2.21 0 4 1.343 4 3 0 1.4-1.278 2.575-3.006 2.907-.542.104-.994.54-.994 1.093m0 3h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        What if I'm not satisfied with the service?
                    </h3>
                    <p class="text-gray-600 dark:text-gray-300">
                        We stand behind our services with a satisfaction guarantee. If we fail to meet our end of the agreement, 
                        your money will be refunded. We're committed to your success and will work tirelessly to ensure you're satisfied.
                    </p>
              </div>

                <!-- FAQ Item 4 -->
                <div class="bg-white dark:bg-gray-800 rounded-xl p-8 shadow-lg border border-gray-200 dark:border-gray-700">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-white mb-4 flex items-center">
                        <svg class="w-6 h-6 text-blue-600 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.228 9c.549-1.165 2.03-2 3.772-2 2.21 0 4 1.343 4 3 0 1.4-1.278 2.575-3.006 2.907-.542.104-.994.54-.994 1.093m0 3h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        How quickly do you respond to inquiries?
                    </h3>
                    <p class="text-gray-600 dark:text-gray-300">
                        We pride ourselves on our responsiveness. All inquiries are answered within 24 working hours, 
                        and you can track your application progress in real-time through our portal.
                    </p>
          </div>
      </div>
  </div>
</section>

    <!-- CTA Section -->
    <section class="bg-gradient-to-br from-blue-600 via-blue-700 to-indigo-800 text-white py-16">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <h2 class="text-3xl md:text-4xl font-bold mb-6">
                Ready to Start Your Migration Journey?
            </h2>
            <p class="text-xl text-blue-100 mb-8 max-w-2xl mx-auto">
                Join hundreds of Nigerians who have successfully migrated with our help. 
                Let us make your dreams a reality.
            </p>
            <div class="flex flex-col sm:flex-row gap-4 justify-center items-center">
                <a href="/portal/login.php" class="inline-flex items-center px-8 py-3 text-lg font-medium text-blue-700 bg-white hover:bg-gray-100 rounded-lg transition-colors duration-300">
                    <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M3 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1z" clip-rule="evenodd"></path>
                    </svg>
                    Start Application
                </a>
                <a href="/contact.php" class="inline-flex items-center px-8 py-3 text-lg font-medium text-white border-2 border-white hover:bg-white hover:text-blue-700 rounded-lg transition-colors duration-300">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"></path>
                    </svg>
                    Ask Questions
                </a>
                <a href="<?php echo WHATSAPP_LINK; ?>" target="_blank" class="inline-flex items-center px-8 py-3 text-lg font-medium text-white bg-green-600 hover:bg-green-700 rounded-lg transition-colors duration-300">
                    <i class="fab fa-whatsapp mr-2 text-xl"></i>
                    Chat on WhatsApp
                </a>
            </div>
        </div>
    </section>

    <!-- Floating WhatsApp Button -->
    <a href="<?php echo WHATSAPP_LINK; ?>" target="_blank" class="fixed bottom-6 right-6 z-50 bg-green-500 hover:bg-green-600 text-white rounded-full p-4 shadow-lg transition-all duration-300 transform hover:scale-110 hover:shadow-xl">
        <i class="fab fa-whatsapp text-2xl"></i>
    </a>

    </body>
    <?php include 'footer.php'; ?>
    </html>