<?php
// Include database configuration
require_once 'config/database.php';

try {
    $pdo = getDatabaseConnection();
    
    // Check if users table exists
    $stmt = $pdo->query("SHOW TABLES LIKE 'users'");
    if ($stmt->rowCount() == 0) {
        echo "ERROR: Users table does not exist!\n";
        exit;
    }
    
    // Check if admin user exists
    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ?");
    $stmt->execute(['admin@migration.ng']);
    $user = $stmt->fetch();
    
    if (!$user) {
        echo "ERROR: Admin user does not exist in database!\n";
        echo "You need to run the portal_tables.sql file to create the admin user.\n";
        exit;
    }
    
    echo "Admin user found:\n";
    echo "ID: " . $user['id'] . "\n";
    echo "Email: " . $user['email'] . "\n";
    echo "First Name: " . $user['firstname'] . "\n";
    echo "Last Name: " . $user['lastname'] . "\n";
    echo "Password Hash: " . $user['password'] . "\n";
    
    // Test password verification
    $testPassword = 'admin123';
    $isValid = password_verify($testPassword, $user['password']);
    
    echo "\nPassword verification test:\n";
    echo "Testing password 'admin123': " . ($isValid ? "VALID" : "INVALID") . "\n";
    
    if (!$isValid) {
        echo "\nThe password hash in the database doesn't match 'admin123'.\n";
        echo "Let's create a new admin user with the correct password:\n";
        
        // Create new admin user with correct password
        $newPassword = 'admin123';
        $newHash = password_hash($newPassword, PASSWORD_DEFAULT);
        
        // Delete existing admin user if exists
        $stmt = $pdo->prepare("DELETE FROM users WHERE email = ?");
        $stmt->execute(['admin@migration.ng']);
        
        // Insert new admin user
        $stmt = $pdo->prepare("INSERT INTO users (firstname, lastname, email, password, created_at) VALUES (?, ?, ?, ?, NOW())");
        $stmt->execute(['Admin', 'User', 'admin@migration.ng', $newHash]);
        
        echo "New admin user created with password: admin123\n";
    }
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}
?> 