<?php
/**
 * Brevo (Sendinblue) Configuration Example
 * 
 * Copy this file to brevo.php and update with your actual values.
 * This file is safe to commit to version control.
 */

return [
    // Brevo API Key - Get this from your Brevo account
    'api_key' => getenv('BREVO_API_KEY') ?: 'YOUR_BREVO_API_KEY_HERE',
    
    // Default sender email
    'sender_email' => 'no-reply@migration.ng',
    
    // Default sender name
    'sender_name' => 'Migration.ng',
    
    // Reply-to email
    'reply_to' => 'services@migration.ng',
    
    // Email templates (optional - for using Brevo templates)
    'templates' => [
        'welcome' => null, // Template ID for welcome emails
        'application_confirmation' => null, // Template ID for application confirmations
        'password_reset' => null, // Template ID for password reset
        'status_update' => null, // Template ID for status updates
    ],
    
    // Debug mode (set to false in production)
    'debug' => false,
    
    // Retry settings
    'max_retries' => 3,
    'retry_delay' => 1000, // milliseconds
]; 