<?php
/**
 * Brevo (Sendinblue) Configuration
 * 
 * This file contains the configuration for Brevo email service.
 * Make sure to set your actual API key in production.
 */

return [
    // Brevo API Key - Get this from your Brevo account
    'api_key' => getenv('BREVO_API_KEY') ?: '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',
    
    // Default sender email
    'sender_email' => 'services@migration.ng',
    
    // Default sender name
    'sender_name' => 'Migration.ng', 
    
    // Reply-to email
    'reply_to' => 'services@migration.ng',
    
    // Email templates (optional - for using Brevo templates)
    'templates' => [
        'welcome' => null, // Template ID for welcome emails
        'application_confirmation' => null, // Template ID for application confirmations
        'password_reset' => null, // Template ID for password reset
        'status_update' => null, // Template ID for status updates
    ],
    
    // Debug mode (set to false in production)
    'debug' => false,
    
    // Retry settings
    'max_retries' => 3,
    'retry_delay' => 1000, // milliseconds
]; 