<?php
/**
 * Debug script for Brevo SDK
 */

echo "Debugging Brevo SDK...\n";
echo "=====================\n\n";

// Check if autoloader exists
$autoloadPath = '/home2/migrati1/public_html/Packages/vendor/autoload.php';
echo "1. Checking autoloader path: $autoloadPath\n";
if (file_exists($autoloadPath)) {
    echo "✓ Autoloader file exists\n";
} else {
    echo "✗ Autoloader file not found\n";
    exit(1);
}

// Include autoloader
echo "\n2. Including autoloader...\n";
require_once $autoloadPath;
echo "✓ Autoloader included\n";

// Check if classes exist
echo "\n3. Checking for Brevo classes...\n";

$classesToCheck = [
    'Brevo\\Client\\Api\\TransactionalEmailsApi',
    'Brevo\\Client\\Configuration', 
    'Brevo\\Client\\Model\\SendSmtpEmail',
    'GuzzleHttp\\Client'
];

foreach ($classesToCheck as $class) {
    if (class_exists($class)) {
        echo "✓ $class exists\n";
    } else {
        echo "✗ $class not found\n";
    }
}

// List all declared classes that contain 'Brevo'
echo "\n4. All Brevo-related classes:\n";
$allClasses = get_declared_classes();
$brevoClasses = array_filter($allClasses, function($class) {
    return strpos($class, 'Brevo') !== false;
});

if (empty($brevoClasses)) {
    echo "No Brevo classes found!\n";
} else {
    foreach ($brevoClasses as $class) {
        echo "- $class\n";
    }
}

// Check composer.json in Packages directory
echo "\n5. Checking Packages/composer.json...\n";
$composerPath = '/home2/migrati1/public_html/Packages/composer.json';
if (file_exists($composerPath)) {
    $composerContent = file_get_contents($composerPath);
    echo "✓ composer.json found\n";
    echo "Content:\n$composerContent\n";
} else {
    echo "✗ composer.json not found\n";
}

echo "\nDebug completed.\n";
?> 