<?php
// Start session for CSRF protection
session_start();

// Define environment
define('ENVIRONMENT', 'production'); // Change to 'development' for debugging

// Include required files
require_once 'config/database.php';
require_once 'config/whatsapp.php';
require_once 'includes/Validator.php';
require_once 'includes/ErrorHandler.php';
require_once 'includes/EmailService.php';
require_once 'includes/UserAuth.php';
require_once 'arrays/countries.php';

// Initialize error handling
ErrorHandler::init();



include("nav.php");
?>

<!doctype html>
<html>
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests">
  <title>Migration.ng - Migration Services</title>
  <meta name="description" content="Professional migration services for European countries. University applications, document legalization, and expert guidance for your migration journey.">
  <meta name="keywords" content="migration, europe, university, document, legalization, expert, guidance, application, tracking, updates, notifications, portal, dashboard, multiple, applications, scholarship, consultation, flexible, updates, easy, modifications, email, support, transparent, pricing, no, hidden, fees, surprises">
  <meta name="author" content="Migration.ng">
  <!-- Favicon -->
  <link rel="icon" type="image/x-icon" href="assets/favicon/favicon.ico">
  <link rel="icon" type="image/png" sizes="16x16" href="assets/favicon/favicon-16x16.png">
  <link rel="icon" type="image/png" sizes="32x32" href="assets/favicon/favicon-32x32.png">
  <link rel="apple-touch-icon" sizes="180x180" href="assets/favicon/apple-touch-icon.png">
  <link rel="manifest" href="assets/favicon/site.webmanifest">

  <script src="https://ibex.bg/umm/assets/js/tailwind.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js" integrity="sha512-894YE6QWD5I59HgZOGReFYm4dnWc1Qt5NtvYSaNcOP+u1T9qYdvdihz0PPSiiqn/+/3e7Jo4EaG7TubfWGUrMQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>

</head>
<body>
    <script>
        tailwind.config = {
  darkMode: 'class',
  theme: {
    extend: {
      colors: {
        primary: {"50":"#eff6ff","100":"#dbeafe","200":"#bfdbfe","300":"#93c5fd","400":"#60a5fa","500":"#3b82f6","600":"#2563eb","700":"#1d4ed8","800":"#1e40af","900":"#1e3a8a"}
      }
    },
    fontFamily: {
      'body': [
    'Inter', 
    'ui-sans-serif', 
    'system-ui', 
    '-apple-system', 
    'system-ui', 
    'Segoe UI', 
    'Roboto', 
    'Helvetica Neue', 
    'Arial', 
    'Noto Sans', 
    'sans-serif', 
    'Apple Color Emoji', 
    'Segoe UI Emoji', 
    'Segoe UI Symbol', 
    'Noto Color Emoji'
  ],
      'sans': [
    'Inter', 
    'ui-sans-serif', 
    'system-ui', 
    '-apple-system', 
    'system-ui', 
    'Segoe UI', 
    'Roboto', 
    'Helvetica Neue', 
    'Arial', 
    'Noto Sans', 
    'sans-serif', 
    'Apple Color Emoji', 
    'Segoe UI Emoji', 
    'Segoe UI Symbol', 
    'Noto Color Emoji'
  ]
    }
  }
}



    </script>
<!-- Hero Section -->
<section class="bg-gradient-to-br from-blue-600 via-blue-700 to-indigo-800 text-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16 lg:py-24">
        <div class="text-center">
            <div class="mb-8">
                <span class="inline-flex items-center px-4 py-2 text-sm font-medium text-blue-100 bg-blue-800/30 rounded-full">
                    <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                    </svg>
                    Trusted by hundreds of Nigerians worldwide
                </span>
            </div>
            
            <h1 class="text-4xl md:text-5xl lg:text-6xl font-bold mb-6">
                Migration Should Be Easy
            </h1>
            <p class="text-xl md:text-2xl text-blue-100 max-w-4xl mx-auto mb-12">
                We provide comprehensive assistance with document authentication, university admissions, and migration services. 
                Your journey to a better future starts here.
            </p>
            
                         <div class="flex flex-col sm:flex-row gap-4 justify-center items-center">
                 <a href="/about.php" class="inline-flex items-center px-8 py-4 text-lg font-medium text-blue-700 bg-white hover:bg-gray-100 rounded-lg transition-all duration-300 transform hover:scale-105">
                     <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                         <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                     </svg>
                     Learn More
                 </a>
                 <a href="/portal/login.php" class="inline-flex items-center px-8 py-4 text-lg font-medium text-white border-2 border-white hover:bg-white hover:text-blue-700 rounded-lg transition-all duration-300">
                     <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                         <path fill-rule="evenodd" d="M3 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1z" clip-rule="evenodd"></path>
                     </svg>
                     Access Portal
                 </a>
                 <a href="<?php echo WHATSAPP_LINK; ?>" target="_blank" class="inline-flex items-center px-8 py-4 text-lg font-medium text-white bg-green-600 hover:bg-green-700 rounded-lg transition-all duration-300 transform hover:scale-105">
                     <i class="fab fa-whatsapp mr-2 text-xl"></i>
                     Chat on WhatsApp
                 </a>
             </div>
        </div>
    </div>
</section>

<!-- Services Section -->
<section class="bg-white dark:bg-gray-900 py-16 lg:py-24" id="services">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-6">
                Make Applications Right From Your Couch
            </h2>
            <p class="text-xl text-gray-600 dark:text-gray-300 max-w-3xl mx-auto">
                We provide comprehensive services with a focus on making your migration journey effortless. 
                Consider it like outsourcing your university and migration applications to us, while you focus on other important things.
            </p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <!-- University Admissions -->
            <div class="bg-gradient-to-br from-blue-50 to-indigo-100 dark:from-blue-900/20 dark:to-indigo-900/20 p-8 rounded-2xl shadow-lg hover:shadow-xl transition-all duration-300 border border-blue-200 dark:border-blue-700">
                <div class="w-16 h-16 bg-blue-100 dark:bg-blue-900 rounded-full flex items-center justify-center mb-6">
                    <svg class="w-8 h-8 text-blue-600 dark:text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 14l9-5-9-5-9 5 9 5z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 14l6.16-3.422a12.083 12.083 0 01.665 6.479A11.952 11.952 0 0012 20.055a11.952 11.952 0 00-6.824-2.998 12.078 12.078 0 01.665-6.479L12 14z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 14l9-5-9-5-9 5 9 5zm0 0l6.16-3.422a12.083 12.083 0 01.665 6.479A11.952 11.952 0 0012 20.055a11.952 11.952 0 00-6.824-2.998 12.078 12.078 0 01.665-6.479L12 14z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-semibold text-gray-900 dark:text-white mb-4">University Admissions</h3>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    We assist in securing bachelor and masters admissions from various universities around the world.
                </p>
                <ul class="text-sm text-gray-600 dark:text-gray-300 space-y-1">
                    <li>• Global university network</li>
                    <li>• Application optimization</li>
                    <li>• Document preparation</li>
                </ul>
            </div>

            <!-- Document Services -->
            <div class="bg-gradient-to-br from-green-50 to-emerald-100 dark:from-green-900/20 dark:to-emerald-900/20 p-8 rounded-2xl shadow-lg hover:shadow-xl transition-all duration-300 border border-green-200 dark:border-green-700">
                <div class="w-16 h-16 bg-green-100 dark:bg-green-900 rounded-full flex items-center justify-center mb-6">
                    <svg class="w-8 h-8 text-green-600 dark:text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-semibold text-gray-900 dark:text-white mb-4">Document Services</h3>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Complete document processing including notarization, attestation, authentication, and embassy legalization.
                </p>
                <ul class="text-sm text-gray-600 dark:text-gray-300 space-y-1">
                    <li>• Notarization services</li>
                    <li>• Ministry attestation</li>
                    <li>• Embassy legalization</li>
                </ul>
            </div>

            <!-- Real-time Updates -->
            <div class="bg-gradient-to-br from-purple-50 to-violet-100 dark:from-purple-900/20 dark:to-violet-900/20 p-8 rounded-2xl shadow-lg hover:shadow-xl transition-all duration-300 border border-purple-200 dark:border-purple-700">
                <div class="w-16 h-16 bg-purple-100 dark:bg-purple-900 rounded-full flex items-center justify-center mb-6">
                    <svg class="w-8 h-8 text-purple-600 dark:text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-semibold text-gray-900 dark:text-white mb-4">Real-time Updates</h3>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Track your application progress in real-time through our comprehensive portal and email notifications.
                </p>
                <ul class="text-sm text-gray-600 dark:text-gray-300 space-y-1">
                    <li>• Live status tracking</li>
                    <li>• Email notifications</li>
                    <li>• Portal dashboard</li>
                </ul>
      </div>

            <!-- Scholarship Consultation -->
            <div class="bg-gradient-to-br from-orange-50 to-amber-100 dark:from-orange-900/20 dark:to-amber-900/20 p-8 rounded-2xl shadow-lg hover:shadow-xl transition-all duration-300 border border-orange-200 dark:border-orange-700">
                <div class="w-16 h-16 bg-orange-100 dark:bg-orange-900 rounded-full flex items-center justify-center mb-6">
                    <svg class="w-8 h-8 text-orange-600 dark:text-orange-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                    </svg>
              </div>
                <h3 class="text-xl font-semibold text-gray-900 dark:text-white mb-4">Scholarship Consultation</h3>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Expert guidance on scholarship opportunities across different countries and universities.
                </p>
                <ul class="text-sm text-gray-600 dark:text-gray-300 space-y-1">
                    <li>• Scholarship research</li>
                    <li>• Application strategy</li>
                    <li>• Eligibility assessment</li>
                </ul>
          </div>
          
            <!-- Multiple Applications -->
            <div class="bg-gradient-to-br from-teal-50 to-cyan-100 dark:from-teal-900/20 dark:to-cyan-900/20 p-8 rounded-2xl shadow-lg hover:shadow-xl transition-all duration-300 border border-teal-200 dark:border-teal-700">
                <div class="w-16 h-16 bg-teal-100 dark:bg-teal-900 rounded-full flex items-center justify-center mb-6">
                    <svg class="w-8 h-8 text-teal-600 dark:text-teal-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path>
                    </svg>
              </div>
                <h3 class="text-xl font-semibold text-gray-900 dark:text-white mb-4">Multiple Applications</h3>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Don't put all your eggs in one basket. Create and track multiple applications simultaneously.
                </p>
                <ul class="text-sm text-gray-600 dark:text-gray-300 space-y-1">
                    <li>• Multiple applications</li>
                    <li>• Simultaneous tracking</li>
                    <li>• Risk diversification</li>
                </ul>
          </div>
          
            <!-- Flexible Updates -->
            <div class="bg-gradient-to-br from-pink-50 to-rose-100 dark:from-pink-900/20 dark:to-rose-900/20 p-8 rounded-2xl shadow-lg hover:shadow-xl transition-all duration-300 border border-pink-200 dark:border-pink-700">
                <div class="w-16 h-16 bg-pink-100 dark:bg-pink-900 rounded-full flex items-center justify-center mb-6">
                    <svg class="w-8 h-8 text-pink-600 dark:text-pink-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-semibold text-gray-900 dark:text-white mb-4">Flexible Updates</h3>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Make updates to your applications easily through email or our portal anytime.
                </p>
                <ul class="text-sm text-gray-600 dark:text-gray-300 space-y-1">
                    <li>• Easy modifications</li>
                    <li>• Portal updates</li>
                    <li>• Email support</li>
                </ul>
            </div>
        </div>
    </div>
</section>

<!-- Pricing Section -->
<section class="bg-gray-50 dark:bg-gray-800">
    <div class="py-8 px-4 mx-auto max-w-screen-xl sm:py-16 lg:px-6">
        <div class="mx-auto max-w-screen-sm text-center mb-8 lg:mb-16">
            <h2 class="mb-4 text-4xl tracking-tight font-extrabold leading-tight text-gray-900 dark:text-white">Transparent Pricing</h2>
            <p class="text-gray-500 sm:text-xl dark:text-gray-400">Clear, competitive pricing for all our services. No hidden fees, no surprises.</p>
        </div>
        <div class="space-y-8 md:grid md:grid-cols-2 lg:grid-cols-3 md:gap-12 md:space-y-0">
            <!-- University Admissions -->
            <div class="text-center bg-gradient-to-br from-blue-50 to-indigo-100 dark:from-blue-900/20 dark:to-indigo-900/20 p-8 rounded-2xl shadow-lg hover:shadow-xl transition-all duration-300 border border-blue-200 dark:border-blue-700">
                <div class="flex justify-center items-center mx-auto mb-4 w-10 h-10 rounded-full bg-blue-100 lg:h-12 lg:w-12 dark:bg-blue-900">
                    <svg class="w-5 h-5 text-blue-600 lg:w-6 lg:h-6 dark:text-blue-300" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                        <path d="M10.394 2.08a1 1 0 00-.788 0l-7 3a1 1 0 000 1.84L5.25 8.051a.999.999 0 01.356-.257l4-1.714a1 1 0 11.788 1.838L7.667 9.088l1.94.831a1 1 0 00.787 0l7-3a1 1 0 000-1.838l-7-3zM3.31 9.397L5 10.12v4.102a8.969 8.969 0 00-1.05-.174 1 1 0 01-.89-.89 11.115 11.115 0 01.25-3.762zM9.3 16.573A9.026 9.026 0 007 14.935v-3.957l1.818.78a3 3 0 002.364 0l5.508-2.361a11.026 11.026 0 01.25 3.762 1 1 0 01-.89.89 8.968 8.968 0 00-5.35 2.524 1 1 0 01-1.4 0zM6 18a1 1 0 001-1v-2.065a8.935 8.935 0 00-2-.712V17a1 1 0 001 1z"></path>
                    </svg>
                </div>
                <h3 class="mb-2 text-xl font-bold text-gray-900 dark:text-white">University Admissions</h3>
                <div class="mb-4">
                    <span class="text-3xl font-bold text-blue-600 dark:text-blue-400">$2,000</span>
                    <span class="text-gray-500 dark:text-gray-400">/application</span>
              </div>
                <p class="text-gray-600 dark:text-gray-300 mb-4">Admission processing to European countries starting from $2,000 USD</p>
                <ul class="text-sm text-gray-600 dark:text-gray-300 space-y-2">
                    <li>• Complete application assistance</li>
                    <li>• Document preparation</li>
                    <li>• Application tracking</li>
                    <li>• Response handling</li>
                </ul>
          </div>

            <!-- Document Officialisation -->
            <div class="text-center bg-gradient-to-br from-green-50 to-emerald-100 dark:from-green-900/20 dark:to-emerald-900/20 p-8 rounded-2xl shadow-lg hover:shadow-xl transition-all duration-300 border border-green-200 dark:border-green-700">
                <div class="flex justify-center items-center mx-auto mb-4 w-10 h-10 rounded-full bg-green-100 lg:h-12 lg:w-12 dark:bg-green-900">
                    <svg class="w-5 h-5 text-green-600 lg:w-6 lg:h-6 dark:text-green-300" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd" d="M6 6V5a3 3 0 013-3h2a3 3 0 013 3v1h2a2 2 0 012 2v3.57A22.952 22.952 0 0110 13a22.95 22.95 0 01-8-1.43V8a2 2 0 012-2h2zm2-1a1 1 0 011-1h2a1 1 0 011 1v1H8V5zm1 5a1 1 0 011-1h.01a1 1 0 110 2H10a1 1 0 01-1-1z" clip-rule="evenodd"></path>
                        <path d="M2 13.692V16a2 2 0 002 2h12a2 2 0 002-2v-2.308A24.974 24.974 0 0110 15c-2.796 0-5.487-.46-8-1.308z"></path>
                    </svg>
              </div>
                <h3 class="mb-2 text-xl font-bold text-gray-900 dark:text-white">Document Officialisation</h3>
                <div class="mb-4">
                    <span class="text-3xl font-bold text-green-600 dark:text-green-400">₦3,000</span>
                    <span class="text-gray-500 dark:text-gray-400">/document</span>
          </div>
                <p class="text-gray-600 dark:text-gray-300 mb-4">Document officialisation starting from ₦3,000</p>
                <ul class="text-sm text-gray-600 dark:text-gray-300 space-y-2">
                    <li>• Notarization services</li>
                    <li>• Ministry attestation</li>
                    <li>• Embassy legalization</li>
                    <li>• Document authentication</li>
                </ul>
              </div>

            <!-- Scholarship Consultation -->
            <div class="text-center bg-gradient-to-br from-purple-50 to-violet-100 dark:from-purple-900/20 dark:to-violet-900/20 p-8 rounded-2xl shadow-lg hover:shadow-xl transition-all duration-300 border border-purple-200 dark:border-purple-700">
                <div class="flex justify-center items-center mx-auto mb-4 w-10 h-10 rounded-full bg-purple-100 lg:h-12 lg:w-12 dark:bg-purple-900">
                    <svg class="w-5 h-5 text-purple-600 lg:w-6 lg:h-6 dark:text-purple-300" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                        <path d="M8.433 7.418c.155-.103.346-.196.567-.267v1.698a2.305 2.305 0 01-.567-.267C8.07 8.34 8 8.114 8 8c0-.114.07-.34.433-.582zM11 12.849v-1.698c.22.071.412.164.567.267.364.243.433.468.433.582 0 .114-.07.34-.433.582a2.305 2.305 0 01-.567.267z"></path>
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-13a1 1 0 10-2 0v.092a4.535 4.535 0 00-1.676.662C6.602 6.234 6 7.009 6 8c0 .99.602 1.765 1.324 2.246.48.32 1.054.545 1.676.662v1.941c-.391-.127-.68-.317-.843-.504a1 1 0 10-1.51 1.31c.562.649 1.413 1.076 2.353 1.253V15a1 1 0 102 0v-.092a4.535 4.535 0 001.676-.662C13.398 13.766 14 12.991 14 12c0-.99-.602-1.765-1.324-2.246A4.535 4.535 0 0011 9.092V7.151c.391.127.68.317.843.504a1 1 0 101.511-1.31c-.563-.649-1.413-1.076-2.354-1.253V5z" clip-rule="evenodd"></path>
                    </svg>
          </div>
                <h3 class="mb-2 text-xl font-bold text-gray-900 dark:text-white">Scholarship Consultation</h3>
                <div class="mb-4">
                    <span class="text-3xl font-bold text-purple-600 dark:text-purple-400">$150</span>
                    <span class="text-gray-500 dark:text-gray-400">/session</span>
              </div>
                <p class="text-gray-600 dark:text-gray-300 mb-4">Expert guidance on scholarship opportunities</p>
                <ul class="text-sm text-gray-600 dark:text-gray-300 space-y-2">
                    <li>• Scholarship research</li>
                    <li>• Application strategy</li>
                    <li>• Eligibility assessment</li>
                    <li>• Documentation guidance</li>
                </ul>
          </div>
      </div>
  </div>
</section>

<section class="bg-white dark:bg-gray-900">
    <div class="py-8 px-4 mx-auto max-w-screen-xl sm:py-16 lg:px-6">
        <div class="mx-auto max-w-screen-sm text-center">
            <h2 class="mb-4 text-4xl tracking-tight font-extrabold leading-tight text-gray-900 dark:text-white">Ready to Start Your Journey?</h2>
            <p class="mb-8 font-light text-gray-500 dark:text-gray-400 md:text-lg">Choose how you'd like to proceed with your migration journey.</p>
            
            <div class="flex flex-col sm:flex-row gap-4 justify-center items-center">
                <a href="/portal/login.php" class="inline-flex items-center px-6 py-3 text-base font-medium text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 rounded-lg dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800 transition-all duration-300">
                    <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd" d="M3 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1z" clip-rule="evenodd"></path>
                    </svg>
                    Access Portal
                </a>
                
                <a href="/contact.php" class="inline-flex items-center px-6 py-3 text-base font-medium text-blue-700 bg-blue-50 hover:bg-blue-100 focus:ring-4 focus:outline-none focus:ring-blue-300 rounded-lg dark:bg-blue-900/20 dark:text-blue-400 dark:hover:bg-blue-900/30 dark:focus:ring-blue-800 transition-all duration-300">
                    <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                        <path d="M2.003 5.884L10 9.882l7.997-3.998A2 2 0 0016 4H4a2 2 0 00-1.997 1.884z"></path>
                        <path d="M18 8.118l-8 4-8-4V14a2 2 0 002 2h12a2 2 0 002-2V8.118z"></path>
                    </svg>
                    Ask Questions
                </a>
  </div>
  
            <p class="mt-6 text-sm text-gray-500 dark:text-gray-400">Not ready to commit? Contact us with your questions first!</p>
    </div>
  </div>
</section>


    <!-- Floating WhatsApp Button -->
    <a href="<?php echo WHATSAPP_LINK; ?>" target="_blank" class="fixed bottom-6 right-6 z-50 bg-green-500 hover:bg-green-600 text-white rounded-full p-4 shadow-lg transition-all duration-300 transform hover:scale-110 hover:shadow-xl">
        <i class="fab fa-whatsapp text-2xl"></i>
    </a>

</body>
<?php include 'footer.php'; ?>
</html>