# Migration.ng User Portal

A comprehensive user portal for managing university applications, document uploads, and application tracking for Migration.ng.

## 🚀 Features

### 🔐 User Authentication & Management
- **Secure Login/Registration**: User registration and authentication system
- **Session Management**: Secure session handling with automatic logout
- **Password Security**: Bcrypt password hashing for security
- **User Profiles**: Personal information management

### 📋 Application Management
- **Dashboard Overview**: Real-time statistics and application summary
- **New Application Submission**: Enhanced application form with validation
- **Application Tracking**: Detailed view of all applications with status updates
- **Application Filtering**: Search and filter applications by status, country, etc.
- **Status Timeline**: Visual progress tracking for each application

### 📁 Document Management
- **Secure File Upload**: Multiple file upload with validation
- **Document Organization**: Categorize documents by type and application
- **File Security**: MIME type validation and safe filename generation
- **Document Preview**: View uploaded documents
- **Storage Management**: Track storage usage and file sizes

### 💬 Communication & Updates
- **Application Updates**: Add notes and updates to applications
- **Status Notifications**: Real-time status change notifications
- **Email Integration**: Automatic email notifications
- **Internal Comments**: Communication between users and admin

### 📊 Analytics & Reporting
- **Application Statistics**: Dashboard with key metrics
- **Progress Tracking**: Visual status indicators
- **Activity History**: Complete audit trail of all actions
- **Export Capabilities**: Download application details

## 🏗️ Architecture

### Technology Stack
- **Backend**: PHP 7.4+ with PDO for database access
- **Frontend**: Tailwind CSS, jQuery, Font Awesome
- **Database**: MySQL 5.7+
- **Security**: CSRF protection, input validation, secure file uploads

### File Structure
```
portal/
├── index.php                 # Dashboard
├── login.php                 # Authentication
├── logout.php                # Session termination
├── applications.php          # Application listing
├── new-application.php       # Application submission
├── application-details.php   # Detailed application view
├── documents.php             # Document management
├── profile.php               # User profile (to be created)
├── sql/
│   └── portal_tables.sql     # Database schema
└── README.md                 # This file
```

## 🛠️ Installation & Setup

### Prerequisites
- PHP 7.4 or higher
- MySQL 5.7 or higher
- Apache/Nginx web server
- Composer (optional)

### Step 1: Database Setup
1. Import the portal database schema:
   ```bash
   mysql -u username -p database_name < portal/sql/portal_tables.sql
   ```

2. The script will create all necessary tables and add required columns to existing tables.

### Step 2: File Permissions
```bash
# Set proper permissions for uploads directory
chmod 755 ../uploads/
chmod 755 ../logs/

# Ensure web server can write to these directories
chown www-data:www-data ../uploads/
chown www-data:www-data ../logs/
```

### Step 3: Configuration
1. Ensure the database configuration in `../config/database.php` is correct
2. Verify email settings in `../includes/EmailService.php`
3. Check file upload limits in PHP configuration

### Step 4: Access the Portal
- Navigate to `https://yourdomain.com/portal/`
- Default admin credentials:
  - Email: `admin@migration.ng`
  - Password: `admin123`

## 📋 Database Schema

### Core Tables

#### `users`
- User authentication and profile information
- Stores encrypted passwords and user details

#### `uni_requests` (Enhanced)
- University application data
- Added columns: `status`, `program`, `intake`, `notes`, `created_at`, `updated_at`

#### `application_updates`
- Timeline and communication for applications
- Links updates to specific applications and users

#### `application_documents`
- Document management and file storage
- Tracks file metadata and associations

#### `user_notifications`
- In-app notification system
- Supports different notification types

#### `user_sessions`
- Enhanced session management
- Tracks user activity and session security

## 🔒 Security Features

### Authentication Security
- **CSRF Protection**: All forms include CSRF tokens
- **Password Hashing**: Bcrypt encryption for passwords
- **Session Security**: Secure session handling with timeout
- **Input Validation**: Comprehensive input sanitization

### File Upload Security
- **MIME Type Validation**: Verifies actual file content
- **File Size Limits**: Configurable upload limits
- **Safe Filenames**: Prevents path traversal attacks
- **Virus Scanning**: Integration ready for antivirus scanning

### Data Protection
- **SQL Injection Prevention**: Prepared statements throughout
- **XSS Prevention**: Output encoding for all user data
- **Access Control**: User-specific data isolation
- **Audit Logging**: Complete activity tracking

## 📧 Email Integration

### Automatic Notifications
- **Application Confirmation**: Sent when applications are submitted
- **Status Updates**: Notifications for status changes
- **Document Upload**: Confirmations for successful uploads
- **Admin Notifications**: Alerts to admin team

### Email Templates
- Professional HTML email templates
- Responsive design for mobile devices
- Branded with Migration.ng styling

## 🎨 User Interface

### Design Principles
- **Modern & Clean**: Professional appearance
- **Responsive**: Works on all device sizes
- **Accessible**: WCAG compliant design
- **Intuitive**: Easy navigation and user experience

### Key Components
- **Dashboard Cards**: Statistics and quick actions
- **Data Tables**: Sortable and filterable lists
- **Modal Dialogs**: Clean interaction patterns
- **Status Indicators**: Visual progress tracking
- **Form Validation**: Real-time feedback

## 🔧 Configuration Options

### Environment Variables
```php
define('ENVIRONMENT', 'production'); // or 'development'
define('UPLOAD_MAX_SIZE', 5242880); // 5MB
define('ALLOWED_FILE_TYPES', ['pdf', 'doc', 'docx', 'jpg', 'jpeg', 'png']);
```

### Email Configuration
```php
// In EmailService.php
$to = "admin@migration.ng";
$from = "no-reply@migration.ng";
```

### Session Configuration
```php
// Session timeout (30 minutes)
ini_set('session.gc_maxlifetime', 1800);
session_set_cookie_params(1800);
```

## 📈 Performance Optimization

### Database Optimization
- **Indexed Queries**: Optimized database indexes
- **Prepared Statements**: Efficient query execution
- **Connection Pooling**: Database connection management

### Frontend Optimization
- **CDN Resources**: Fast loading of external libraries
- **Minified Assets**: Reduced file sizes
- **Caching**: Browser and server-side caching

## 🐛 Troubleshooting

### Common Issues

#### Database Connection Errors
- Verify database credentials in `config/database.php`
- Check MySQL service is running
- Ensure database exists and user has proper permissions

#### File Upload Issues
- Check PHP `upload_max_filesize` and `post_max_size` settings
- Verify directory permissions for uploads folder
- Check available disk space

#### Session Issues
- Ensure session directory is writable
- Check session configuration in PHP
- Verify cookie settings

### Error Logging
- All errors are logged to `../logs/error.log`
- Check logs for detailed error information
- Enable development mode for debugging

## 🚀 Future Enhancements

### Planned Features
- **Mobile App**: Native mobile application
- **Payment Integration**: Online payment processing
- **Advanced Analytics**: Detailed reporting and insights
- **API Development**: RESTful API for third-party integrations
- **Multi-language Support**: Internationalization
- **Advanced Notifications**: Push notifications and SMS

### Technical Improvements
- **Caching Layer**: Redis/Memcached integration
- **Queue System**: Background job processing
- **Microservices**: Service-oriented architecture
- **Containerization**: Docker deployment
- **CI/CD Pipeline**: Automated testing and deployment

## 📞 Support

For technical support or questions:
- **Email**: services@migration.ng
- **Documentation**: This README and inline code comments
- **Issues**: Check error logs in `../logs/error.log`

## 📄 License

This portal system is proprietary software developed for Migration.ng.

---

**Note**: This portal is designed for production use with comprehensive security measures. Always keep dependencies updated and monitor error logs regularly. 