<?php
// Start session for user authentication
session_start();

// Include required files
require_once '../config/database.php';
require_once '../includes/Validator.php';
require_once '../includes/ErrorHandler.php';
require_once '../includes/UserAuth.php';

// Initialize error handling
ErrorHandler::init();

// Require admin access
UserAuth::requireAdmin();

// Get current user
$currentUser = UserAuth::getCurrentUser();

// Get statistics for admin dashboard
try {
    $pdo = getDatabaseConnection();
    
    // Get user statistics
    $stmt = $pdo->query("SELECT COUNT(*) as total_users FROM users WHERE role = 'user'");
    $totalUsers = $stmt->fetch()['total_users'];
    
    $stmt = $pdo->query("SELECT COUNT(*) as total_applications FROM portal_applications");
    $totalApplications = $stmt->fetch()['total_applications'];
    
    $stmt = $pdo->query("SELECT COUNT(*) as pending_applications FROM portal_applications WHERE status = 'pending'");
    $pendingApplications = $stmt->fetch()['pending_applications'];
    
    // Get document request statistics
    $stmt = $pdo->query("SELECT COUNT(*) as total_document_requests FROM document_requests");
    $totalDocumentRequests = $stmt->fetch()['total_document_requests'];
    
    $stmt = $pdo->query("SELECT COUNT(*) as pending_document_requests FROM document_requests WHERE status = 'pending'");
    $pendingDocumentRequests = $stmt->fetch()['pending_document_requests'];
    
    // Get document statistics (both application documents and officialisation documents)
    $stmt = $pdo->query("SELECT COUNT(*) as total_documents FROM application_documents");
    $applicationDocuments = $stmt->fetch()['total_documents'];
    
    $stmt = $pdo->query("SELECT COUNT(*) as total_documents FROM officialisation_documents");
    $officialisationDocuments = $stmt->fetch()['total_documents'];
    
    $totalDocuments = $applicationDocuments + $officialisationDocuments;
    
} catch (Exception $e) {
    error_log("Admin dashboard error: " . $e->getMessage());
    $totalUsers = $totalApplications = $pendingApplications = $totalDocuments = 0;
}

// Generate CSRF token
$csrfToken = Validator::generateCSRFToken();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - Migration.ng Portal</title>
    <script src="https://ibex.bg/umm/assets/js/tailwind.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body class="bg-gray-50 min-h-screen">
    <!-- Navigation -->
    <nav class="bg-white shadow-sm border-b">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-16">
                <div class="flex items-center">
                    <a href="/" class="flex items-center">
                        <img src="/assets/images/m..png" alt="Migration.ng" class="h-8 w-auto">
                    </a>
                    <span class="ml-4 text-lg font-semibold text-gray-900">Admin Panel</span>
                </div>
                <div class="flex items-center space-x-4">
                    <span class="text-sm text-gray-600">
                        Welcome, <?php echo htmlspecialchars($currentUser['firstname'] . ' ' . $currentUser['lastname']); ?>
                        <span class="bg-blue-100 text-blue-800 text-xs font-medium px-2.5 py-0.5 rounded ml-2">
                            <?php echo UserAuth::getRoleDisplayName($currentUser['role']); ?>
                        </span>
                    </span>
                    <a href="index.php" class="text-blue-600 hover:text-blue-500 text-sm">Portal</a>
                    <a href="logout.php" class="text-red-600 hover:text-red-500 text-sm">Logout</a>
                </div>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
        <!-- Page Header -->
        <div class="px-4 py-6 sm:px-0">
            <h1 class="text-3xl font-bold text-gray-900">Admin Dashboard</h1>
            <p class="mt-2 text-gray-600">Manage users, applications, and system settings</p>
        </div>

        <!-- Statistics Cards -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-6 gap-6 mb-8">
            <div class="bg-white overflow-hidden shadow rounded-lg">
                <div class="p-5">
                    <div class="flex items-center">
                        <div class="flex-shrink-0">
                            <i class="fas fa-users text-blue-600 text-2xl"></i>
                        </div>
                        <div class="ml-5 w-0 flex-1">
                            <dl>
                                <dt class="text-sm font-medium text-gray-500 truncate">Total Users</dt>
                                <dd class="text-lg font-medium text-gray-900"><?php echo $totalUsers; ?></dd>
                            </dl>
                        </div>
                    </div>
                </div>
            </div>

            <div class="bg-white overflow-hidden shadow rounded-lg">
                <div class="p-5">
                    <div class="flex items-center">
                        <div class="flex-shrink-0">
                            <i class="fas fa-file-alt text-green-600 text-2xl"></i>
                        </div>
                        <div class="ml-5 w-0 flex-1">
                            <dl>
                                <dt class="text-sm font-medium text-gray-500 truncate">Total Applications</dt>
                                <dd class="text-lg font-medium text-gray-900"><?php echo $totalApplications; ?></dd>
                            </dl>
                        </div>
                    </div>
                </div>
            </div>

            <div class="bg-white overflow-hidden shadow rounded-lg">
                <div class="p-5">
                    <div class="flex items-center">
                        <div class="flex-shrink-0">
                            <i class="fas fa-clock text-yellow-600 text-2xl"></i>
                        </div>
                        <div class="ml-5 w-0 flex-1">
                            <dl>
                                <dt class="text-sm font-medium text-gray-500 truncate">Pending Applications</dt>
                                <dd class="text-lg font-medium text-gray-900"><?php echo $pendingApplications; ?></dd>
                            </dl>
                        </div>
                    </div>
                </div>
            </div>

            <div class="bg-white overflow-hidden shadow rounded-lg">
                <div class="p-5">
                    <div class="flex items-center">
                        <div class="flex-shrink-0">
                            <i class="fas fa-file-upload text-purple-600 text-2xl"></i>
                        </div>
                        <div class="ml-5 w-0 flex-1">
                            <dl>
                                <dt class="text-sm font-medium text-gray-500 truncate">Total Documents</dt>
                                <dd class="text-lg font-medium text-gray-900"><?php echo $totalDocuments; ?></dd>
                            </dl>
                        </div>
                    </div>
                </div>
            </div>

            <div class="bg-white overflow-hidden shadow rounded-lg">
                <div class="p-5">
                    <div class="flex items-center">
                        <div class="flex-shrink-0">
                            <i class="fas fa-stamp text-indigo-600 text-2xl"></i>
                        </div>
                        <div class="ml-5 w-0 flex-1">
                            <dl>
                                <dt class="text-sm font-medium text-gray-500 truncate">Document Requests</dt>
                                <dd class="text-lg font-medium text-gray-900"><?php echo $totalDocumentRequests; ?></dd>
                            </dl>
                        </div>
                    </div>
                </div>
            </div>

            <div class="bg-white overflow-hidden shadow rounded-lg">
                <div class="p-5">
                    <div class="flex items-center">
                        <div class="flex-shrink-0">
                            <i class="fas fa-clock text-orange-600 text-2xl"></i>
                        </div>
                        <div class="ml-5 w-0 flex-1">
                            <dl>
                                <dt class="text-sm font-medium text-gray-500 truncate">Pending Requests</dt>
                                <dd class="text-lg font-medium text-gray-900"><?php echo $pendingDocumentRequests; ?></dd>
                            </dl>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Admin Actions -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <!-- User Management -->
            <div class="bg-white shadow rounded-lg p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">User Management</h3>
                <div class="space-y-3">
                    <a href="admin-users.php" class="block w-full text-left px-4 py-2 text-sm text-blue-600 hover:bg-blue-50 rounded-md">
                        <i class="fas fa-users mr-2"></i>View All Users
                    </a>
                    <a href="admin-create-user.php" class="block w-full text-left px-4 py-2 text-sm text-blue-600 hover:bg-blue-50 rounded-md">
                        <i class="fas fa-user-plus mr-2"></i>Create New User
                    </a>
                    <a href="admin-user-roles.php" class="block w-full text-left px-4 py-2 text-sm text-blue-600 hover:bg-blue-50 rounded-md">
                        <i class="fas fa-user-shield mr-2"></i>Manage User Roles
                    </a>
                </div>
            </div>

            <!-- Application Management -->
            <div class="bg-white shadow rounded-lg p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">Application Management</h3>
                <div class="space-y-3">
                    <a href="admin-applications.php" class="block w-full text-left px-4 py-2 text-sm text-green-600 hover:bg-green-50 rounded-md">
                        <i class="fas fa-file-alt mr-2"></i>View All Applications
                    </a>
                    <a href="admin-pending-applications.php" class="block w-full text-left px-4 py-2 text-sm text-yellow-600 hover:bg-yellow-50 rounded-md">
                        <i class="fas fa-clock mr-2"></i>Pending Applications
                    </a>
                    <a href="admin-application-status.php" class="block w-full text-left px-4 py-2 text-sm text-green-600 hover:bg-green-50 rounded-md">
                        <i class="fas fa-edit mr-2"></i>Update Application Status
                    </a>
                </div>
            </div>

            <!-- System Management -->
            <div class="bg-white shadow rounded-lg p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">System Management</h3>
                <div class="space-y-3">
                    <a href="admin-documents.php" class="block w-full text-left px-4 py-2 text-sm text-purple-600 hover:bg-purple-50 rounded-md">
                        <i class="fas fa-file-upload mr-2"></i>Document Management
                    </a>
                    <a href="admin-notifications.php" class="block w-full text-left px-4 py-2 text-sm text-blue-600 hover:bg-blue-50 rounded-md">
                        <i class="fas fa-bell mr-2"></i>Send Notifications
                    </a>
                    <a href="emails/" class="block w-full text-left px-4 py-2 text-sm text-blue-600 hover:bg-blue-50 rounded-md">
                        <i class="fas fa-envelope mr-2"></i>Email Management
                    </a>
                    <a href="admin-settings.php" class="block w-full text-left px-4 py-2 text-sm text-gray-600 hover:bg-gray-50 rounded-md">
                        <i class="fas fa-cog mr-2"></i>System Settings
                    </a>
                </div>
            </div>
        </div>
    </div>
</body>
</html> 