<?php
// Start session
session_start();

// Include required files
require_once '../config/database.php';
require_once '../includes/Validator.php';
require_once '../includes/ErrorHandler.php';

// Initialize error handling
ErrorHandler::init();

try {
    // If user is logged in, log the logout
    if (isset($_SESSION['user_id'])) {
        $pdo = getDatabaseConnection();
        
        // Update last activity in user_sessions table if it exists
        if (isset($_SESSION['session_id'])) {
            $stmt = $pdo->prepare("UPDATE user_sessions SET is_active = FALSE, last_activity = NOW() WHERE session_id = ?");
            $stmt->execute([$_SESSION['session_id']]);
        }
        
        // Log the logout
        error_log("User ID " . $_SESSION['user_id'] . " logged out at " . date('Y-m-d H:i:s'));
    }
} catch (Exception $e) {
    error_log("Logout error: " . $e->getMessage());
}

// Destroy all session data
$_SESSION = array();

// If a session cookie is used, destroy it
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}

// Destroy the session
session_destroy();

// Redirect to login page
header('Location: login.php');
exit();
?> 