-- Email Verification Migration
-- Add email verification fields to users table

-- Add email verification fields
ALTER TABLE users 
ADD COLUMN email_verified BOOLEAN DEFAULT FALSE AFTER is_active,
ADD COLUMN email_verification_token VARCHAR(255) NULL AFTER email_verified,
ADD COLUMN email_verification_expires TIMESTAMP NULL AFTER email_verification_token;

-- Create index for email verification token
CREATE INDEX idx_users_email_verification_token ON users(email_verification_token);

-- Create index for email verification status
CREATE INDEX idx_users_email_verified ON users(email_verified);

-- Update existing users to have verified emails (optional - for existing data)
-- UPDATE users SET email_verified = TRUE WHERE email_verified IS NULL; 