<?php
/**
 * Email Verification Migration Script
 * Run this script to add email verification fields to the users table
 */

// Include database configuration
require_once 'config/database.php';

echo "Starting email verification migration...\n";

try {
    $pdo = getDatabaseConnection();
    
    // Check if email_verified column already exists
    $stmt = $pdo->prepare("SHOW COLUMNS FROM users LIKE 'email_verified'");
    $stmt->execute();
    $columnExists = $stmt->fetch();
    
    if ($columnExists) {
        echo "Email verification fields already exist. Migration not needed.\n";
        exit(0);
    }
    
    // Add email verification fields
    echo "Adding email verification fields to users table...\n";
    
    $pdo->exec("ALTER TABLE users 
                ADD COLUMN email_verified BOOLEAN DEFAULT FALSE AFTER is_active,
                ADD COLUMN email_verification_token VARCHAR(255) NULL AFTER email_verified,
                ADD COLUMN email_verification_expires TIMESTAMP NULL AFTER email_verification_token");
    
    echo "✓ Email verification fields added successfully.\n";
    
    // Create indexes
    echo "Creating indexes...\n";
    
    $pdo->exec("CREATE INDEX idx_users_email_verification_token ON users(email_verification_token)");
    $pdo->exec("CREATE INDEX idx_users_email_verified ON users(email_verified)");
    
    echo "✓ Indexes created successfully.\n";
    
    // Update existing users to have verified emails (optional)
    echo "Updating existing users to have verified emails...\n";
    
    $stmt = $pdo->prepare("UPDATE users SET email_verified = TRUE WHERE email_verified IS NULL");
    $stmt->execute();
    $updatedCount = $stmt->rowCount();
    
    echo "✓ Updated {$updatedCount} existing users to have verified emails.\n";
    
    echo "\n🎉 Email verification migration completed successfully!\n";
    echo "New users will now need to verify their email addresses before logging in.\n";
    
} catch (Exception $e) {
    echo "❌ Migration failed: " . $e->getMessage() . "\n";
    exit(1);
}
?> 