<?php
/**
 * Test script to check Brevo SDK namespace structure
 */

// Include the autoloader
$autoloadPath = '/home2/migrati1/public_html/Packages/vendor/autoload.php';
if (!file_exists($autoloadPath)) {
    die("Error: Brevo SDK not found. Please run 'composer install' in the Packages directory.\n");
}
require_once $autoloadPath;

echo "Testing Brevo SDK Namespace Structure...\n";
echo "========================================\n\n";

// Test different namespace variations
$namespaces = [
    'Brevo\\Client\\Api\\TransactionalEmailsApi',
    'Brevo\\Client\\Configuration',
    'Brevo\\Client\\Model\\SendSmtpEmail',
    'Brevo\\Api\\TransactionalEmailsApi',
    'Brevo\\Configuration',
    'Brevo\\Model\\SendSmtpEmail',
    'Sendinblue\\Client\\Api\\TransactionalEmailsApi',
    'Sendinblue\\Client\\Configuration',
    'Sendinblue\\Client\\Model\\SendSmtpEmail'
];

foreach ($namespaces as $namespace) {
    echo "Testing: $namespace\n";
    if (class_exists($namespace)) {
        echo "✓ Class exists: $namespace\n";
    } else {
        echo "✗ Class not found: $namespace\n";
    }
}

echo "\n========================================\n";
echo "Namespace test completed.\n";

// Try to get available classes in Brevo namespace
echo "\nAvailable classes in Brevo namespace:\n";
$classes = get_declared_classes();
$brevoClasses = array_filter($classes, function($class) {
    return strpos($class, 'Brevo') === 0 || strpos($class, 'Sendinblue') === 0;
});

foreach ($brevoClasses as $class) {
    echo "- $class\n";
}
?> 