<?php
/**
 * Simple test script to debug Brevo API issues
 */

// Include the autoloader
require_once '/home2/migrati1/public_html/Packages/vendor/autoload.php';

use Brevo\Client\Api\TransactionalEmailsApi;
use Brevo\Client\Configuration;
use Brevo\Client\Model\SendSmtpEmail;
use GuzzleHttp\Client;

echo "Simple Brevo API Test\n";
echo "====================\n\n";

try {
    // Load configuration
    $config = require '/home2/migrati1/public_html/migration.ng/config/brevo.php';
    $apiKey = $config['api_key'];
    
    echo "1. API Key loaded: " . substr($apiKey, 0, 20) . "...\n";
    
    // Initialize Brevo API
    $brevoConfig = Configuration::getDefaultConfiguration()
        ->setApiKey('api-key', $apiKey);
        
    $apiInstance = new TransactionalEmailsApi(
        new Client(),
        $brevoConfig
    );
    
    echo "2. Brevo API initialized successfully\n";
    
    // Create email
    $sendSmtpEmail = new SendSmtpEmail();
    $sendSmtpEmail['to'] = [['email' => 'test@example.com']];
    $sendSmtpEmail['subject'] = 'Test Email from Brevo';
    $sendSmtpEmail['htmlContent'] = '<h1>Test Email</h1><p>This is a test email from Brevo API.</p>';
    $sendSmtpEmail['sender'] = ['email' => $config['sender_email'], 'name' => $config['sender_name']];
    
    echo "3. Email object created\n";
    
    // Send email
    echo "4. Attempting to send email...\n";
    $result = $apiInstance->sendTransacEmail($sendSmtpEmail);
    
    echo "5. Email sent successfully!\n";
    echo "   Message ID: " . $result->getMessageId() . "\n";
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    echo "Error type: " . get_class($e) . "\n";
    
    if (method_exists($e, 'getResponseBody')) {
        echo "Response body: " . $e->getResponseBody() . "\n";
    }
    
    if (method_exists($e, 'getResponseHeaders')) {
        echo "Response headers: " . print_r($e->getResponseHeaders(), true) . "\n";
    }
}

echo "\nTest completed.\n";
?> 