<?php
/**
 * Test script for Brevo email integration
 * 
 * This script tests the EmailService with Brevo integration.
 * Run this script to verify that emails are being sent correctly.
 */

// Include required files
require_once 'includes/EmailService.php';

// Make sure the external Packages directory exists
if (!file_exists('/home2/migrati1/public_html/Packages/vendor/autoload.php')) {
    die("Error: Brevo SDK not found. Please run 'composer install' in the Packages directory.\n");
}

// Test configuration
$testEmail = 'test@example.com'; // Replace with your test email
$testData = [
    'firstname' => 'John',
    'lastname' => 'Doe',
    'email' => $testEmail,
    'country' => 'Nigeria',
    'university' => 'Test University',
    'degree' => 'Bachelor\'s',
    'program' => 'Computer Science'
];

echo "Testing Brevo Email Integration...\n";
echo "=====================================\n\n";

try {
    // Test 1: Contact form email
    echo "1. Testing contact form email...\n";
    $contactData = [
        'name' => 'Test User',
        'email' => $testEmail,
        'phone' => '+2341234567890',
        'message' => 'This is a test message from the Brevo integration test.'
    ];
    
    $result = EmailService::sendContactForm($contactData);
    echo $result ? "✓ Contact form email sent successfully\n" : "✗ Contact form email failed\n";
    
    // Test 2: University application email
    echo "\n2. Testing university application email...\n";
    $result = EmailService::sendUniversityApplication($testData);
    echo $result ? "✓ University application email sent successfully\n" : "✗ University application email failed\n";
    
    // Test 3: User confirmation email
    echo "\n3. Testing user confirmation email...\n";
    $result = EmailService::sendUserConfirmation($testData);
    echo $result ? "✓ User confirmation email sent successfully\n" : "✗ User confirmation email failed\n";
    
    // Test 4: Welcome email
    echo "\n4. Testing welcome email...\n";
    $result = EmailService::sendWelcomeEmail($testData);
    echo $result ? "✓ Welcome email sent successfully\n" : "✗ Welcome email failed\n";
    
    // Test 5: Password reset email
    echo "\n5. Testing password reset email...\n";
    $resetToken = 'test_token_' . time();
    $result = EmailService::sendPasswordReset($testEmail, $resetToken);
    echo $result ? "✓ Password reset email sent successfully\n" : "✗ Password reset email failed\n";
    
    // Test 6: Application status update email
    echo "\n6. Testing application status update email...\n";
    $statusData = array_merge($testData, ['status' => 'Under Review']);
    $result = EmailService::sendApplicationStatusUpdate($statusData);
    echo $result ? "✓ Application status update email sent successfully\n" : "✗ Application status update email failed\n";
    
    echo "\n=====================================\n";
    echo "Test completed! Check your email at: $testEmail\n";
    echo "Also check your Brevo dashboard for delivery status.\n";
    
} catch (Exception $e) {
    echo "Error during testing: " . $e->getMessage() . "\n";
    echo "Please check your Brevo API key configuration.\n";
}
?> 