<?php
// Include database configuration
require_once 'config/database.php';

try {
    $pdo = getDatabaseConnection();
    
    echo "Updating database to add role-based access control...\n\n";
    
    // Check if role column exists
    $stmt = $pdo->query("SHOW COLUMNS FROM users LIKE 'role'");
    if ($stmt->rowCount() == 0) {
        echo "Adding role column to users table...\n";
        $pdo->exec("ALTER TABLE users ADD COLUMN role ENUM('user', 'admin', 'moderator') DEFAULT 'user' AFTER phone");
        echo "✓ Role column added successfully\n\n";
    } else {
        echo "✓ Role column already exists\n\n";
    }
    
    // Update admin user to have admin role
    echo "Updating admin user role...\n";
    $stmt = $pdo->prepare("UPDATE users SET role = 'admin' WHERE email = ?");
    $stmt->execute(['admin@migration.ng']);
    
    if ($stmt->rowCount() > 0) {
        echo "✓ Admin user role updated successfully\n\n";
    } else {
        echo "! Admin user not found or already has admin role\n\n";
    }
    
    // Show current users and their roles
    echo "Current users and their roles:\n";
    echo "----------------------------------------\n";
    $stmt = $pdo->query("SELECT id, firstname, lastname, email, role FROM users ORDER BY id");
    $users = $stmt->fetchAll();
    
    foreach ($users as $user) {
        echo sprintf("ID: %d | Name: %s %s | Email: %s | Role: %s\n", 
            $user['id'], 
            $user['firstname'], 
            $user['lastname'], 
            $user['email'], 
            $user['role']
        );
    }
    
    echo "\n✓ Database update completed successfully!\n";
    echo "\nYou can now:\n";
    echo "1. Login with admin@migration.ng / admin123\n";
    echo "2. Access the admin panel at /portal/admin.php\n";
    echo "3. Create new users with different roles\n";
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}
?> 